<?php

namespace Database\Seeders;

use App\Models\LegalPage;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\URL;

class LegalPagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $site_url_replaced = config('app.url');
        $site_url_replaced = str_replace('http://', '', $site_url_replaced);
        $site_url_replaced = str_replace('https://', '', $site_url_replaced);
        
        LegalPage::create([
            'title' => 'Privacy Policy',
            'slug' => 'privacy-policy',
            'content' => '<p>'.config('app.name').'&nbsp;collects and manages user data according to the following Privacy Policy. By using the Website, you agree to the terms of this Privacy Policy.</p><p><strong>● Cookies</strong></p><p>Cookies are small-sized text files saved by your browser on your computer, and the browser will send this file to our server only when you visit our website. We use cookies technology to improve the quality of&nbsp;<a href="'.URL::to('/').'">'.config('app.name').'</a>&nbsp;website. By default, your browser is set to allow cookies, but you can always choose to block cookies in your browser&rsquo;s settings.</p><p><strong>● The Information We Collect</strong></p><p>In some cases, we collect information regarding what pages within site you look at, how long you look at them for and how many times you look at them. This information allows us to optimize our website and make sure that Appurse.com provide the best possible experience for our users.</p><p><strong>● How We Use the Information</strong></p><p>We may use this information to learn how this website is being used and to gauge the popularity of different parts of the site. Knowing how many times specific sections of the site are viewed, we can adjust our contents and make improvements to optimize our service.</p><p><strong>● Track abuse if it occurs.</strong></p><p>We will disclose information we have when required to do so by law, for example, in response to a court order. We may disclose such information in response to a law enforcement agency&rsquo;s request.</p><p><strong>● Property Claim</strong></p><p>The trademarks and logos of all the merchants displayed on the website are the property of their respective owners. '.config('app.name').'&nbsp;is not affiliated or associated with any of them.</p><p><strong>● Safety Concern</strong></p><p>Please be assured that '.config('app.name').' only provides original apps and apk files without any cheat, modifications or virus. Your personal information will NOT be shared with any other third party without your explicit permission.</p><p><strong>● Policy Change</strong></p><p>We may amend this Privacy Policy from time to time. Use of information we collect now is subject to the Privacy Policy in effect at the time such information is used. A user is bound by any changes to the Privacy Policy when he or she uses the Services after such changes have been first posted.</p><p>Should you have any question or concern, please&nbsp;contact us.</p>',
            'visibility' => 1
        ]);

        LegalPage::create([
            'title' => 'Shipping Policy',
            'slug' => 'shipping-policy',
            'content' => '<p><strong>1. IS SHIPPING FREE?</strong></p><p><em>YES.</em></p><p><strong>2. HOW LONG WILL MY ORDER TAKE TO DISPATCHED ?</strong></p><p><em>We just need no longer than 1 to 5 business day to deal with your order., Please contact us firstly ( contact@'.$site_url_replaced.' ) for more details. </em></p><p><strong>3. HOW LONG WILL MY ORDER TAKE TO SHIP ?</strong></p><p><em>For Standard Tracked Shipping, it takes 1~7 working days to arrive after dispatched.</em></p><p><em>During rush days, please estimate extra 5 business days more than usual.</em></p><p><strong>4. CAN I TRACK MY ORDER?</strong></p><p><em>5 working day after your parcel is shipped, you will receive an email with the courier\'s details and your consignment number, this can be used to track your order.</em></p><p><strong>5. CAN I CHANGE MY ADDRESS?</strong></p><p>Please contact us ( contact@'.$site_url_replaced.' ) before your item has been dispatched.</p><p> </p><p>Any Other Questions About Shipping Please Contact Us ( contact@'.$site_url_replaced.' )</p>',
            'visibility' => true
        ]);

        LegalPage::create([
            'title' => 'Return & Refund policy',
            'slug' => 'return-and-refund-policy',
            'content' => '<p><span>More than anything we want you to be happy with your purchase!! If something doesn’t look for feel right, please email us at <strong>support@'.$site_url_replaced.'</strong></span><span>&nbsp;and we\'ll make it right!&nbsp;</span></p><p><span>Also please be informed that placing an order means that you accept all the terms mentioned below</span></p><h3><b>CANCELLATION &amp; MODIFICATION</b></h3><p><span>If you change your mind about your purchase, please sending us an email to <strong>support@'.$site_url_replaced.'</strong>&nbsp;and provide your order number and the modification you would like to make. We’ll confirm once the modification or cancellation has been made.</span></p><p><span>Your order is only eligible to be cancelled and modified&nbsp;</span><b>within 02 hours</b><span>&nbsp;of placing the order. After that time, the order is locked for processing and can no longer be cancelled.&nbsp;</span></p><p><span>Please be informed that:</span></p><ul><li><span>A management and transaction fee (20% of your total order value) will be applied for the cancellation.</span></li><li><span>We are not guaranteed to deliver your order in timely manner if your order needs design modification as it will take us much longer to modify your design in this holiday seasons</span></li><li><span>Items can be return/exchange and get a refund within 30 days of receiving the product, in an unlikely event of the damaged, defective or wrong item delivered to you.</span></li></ul><p><span><em><strong>NOTE: Please keep in mind that purchasing means accepting all the terms mentioned above.</strong></em></span></p><ul></ul><h3><b>REPLACEMENT &amp; REFUND&nbsp;</b></h3><p><span>At this time we do not offer Return in any case, we just offer replacement. If your item is defective, you don\'t need to return the item and we will resend you a replacement for free.</span></p><p><span>Due to hygiene reasons and the fact that our products are customized,&nbsp;</span><b>we do not exchange or issue full refund unless an item you received has a major problem</b><span>. This is when the item is:</span></p><ul><li>Significantly different from the description or sample shown to you;</li><li>Damaged due to the fault of our factory or the carrier;</li><li>Not what you ordered;</li></ul><p><em><strong>Please be noted that with other cases (not mentioned above) we only offer partial refund (excluding shipping fee)</strong></em></p><ul></ul><p>Please allow the 20% difference between advertised images and the actual item you received as sometimes advertised images may slightly different from actual item in terms of color due to the lighting during photo shooting or the monitor\'s display</p><p><span>To file a claim, please send us an email to <strong>support@'.$site_url_replaced.'&nbsp;</strong></span><span>and include the following information (this is a must):</span></p><ul><li><span>Order number</span></li><li><span>Video/ photo of the defective product</span></li></ul><p><i><span>&nbsp; &nbsp; &nbsp; If your claim is in regards to a printing error, please include photographs of the error.&nbsp;</span></i></p><p><i><span>&nbsp; &nbsp; &nbsp; If your claim is in regards to a print size or placement issue, please include a measuring tape, stick, or ruler in the photographs of affected garments.</span></i></p><ul><li><span>Full delivery address</span></li><li><span>Contact telephone number</span></li></ul><p>Our support team will review the photos/videos you send of the defective item and, if your item is eligible, we will resend the product to you for no additional cost to you. In the rare case that sending a replacement product is not practical, we will reimburse you the full cost of the eligible product (including shipping costs).</p><h3><b>INCORRECT ADDRESS</b></h3><p>For orders shipped to the wrong address due to a customer inputting the incorrect address:</p><p><span></span><span>- We are not responsible if your order gets delivered to the wrong address or returned to sender (as all of the items would be donated right after they come back to our warehouse)<br></span></p><p><span>- The customer must cover the cost of ordering replacement items&nbsp;</span></p><p><span>So please be extremely careful when entering your shipping address.&nbsp;</span></p><p><span>Customer service is our #1 priority and we will do whatever we can to take care of you. Thank you for considering mordenly.com</span><span>&nbsp;and if you have any questions, please don\'t hesitate to contact us via:&nbsp;&nbsp;<strong>support@'.$site_url_replaced.'</strong></span></p>',
            'visibility' => true
        ]);

        LegalPage::create([
            'title' => 'Cancellation Policy',
            'slug' => 'cancellation-policy',
            'content' => '<p><span>Please be noticed that orders only can be cancelled or modified within 2 hours after being placed.</span></p><p><span>If you want&nbsp; to modify or cancel your order, please contact us&nbsp;<a href="'.route('contactus').'"><strong>HERE&nbsp;</strong></a></span><span>to send your request, our customer support team is willing to support you.</span></p><p><span>Please notice:</span></p><p><span>*If your order has been processed already, you cannot cancel or modify it, therefore, please contact our Customer Service&nbsp;<a href="'.route('contactus').'"><strong>HERE&nbsp;</strong></a></span><span>as quickly as possible.&nbsp;</span></p><p><span>*If you insist to cancel/modify a processing order, you might be charged 50% the payment.&nbsp;</span></p><p><span>*If your order was shipped out already, nothing can be changed any longer.</span></p>',
            'visibility' => true
        ]);

        LegalPage::create([
            'title' => 'Payment Method',
            'slug' => 'payment-method',
            'content' => '<p>Payments methods include<span>&nbsp;</span><strong>PayPal</strong><span>&nbsp;</span>and<span>&nbsp;</span><strong>Credit</strong><span>&nbsp;</span>cards.</p><p>PayPal is a safer, easier way to send and receive money online. When you select<span>&nbsp;</span><strong>PayPal</strong><span>&nbsp;</span>as the payment method, you will be linked to the<span>&nbsp;</span><strong>PayPal</strong><span>&nbsp;</span>site where you can make payment.</p><p>PayPal can be used to purchase items by<span>&nbsp;</span><strong>Credit Card</strong><span>&nbsp;</span>(Visa, MasterCard, Discover, and American Express),<span>&nbsp;</span><strong>Debit Card</strong>, or<span>&nbsp;</span><strong>E-check</strong><span>&nbsp;</span>(i.e. using your regular Bank Account).</p><p>1) After viewing your items on your shopping cart page, you can click and check out with PayPal. Then you will leave our site and enter<span>&nbsp;</span><strong>PayPal</strong>’s website.<br>2) You can sign in to your<span>&nbsp;</span><strong>PayPal</strong><span>&nbsp;</span>account, or you can create a new one if you haven’t got one.<br>3) You can use the<span>&nbsp;</span><strong>PayPal</strong><span>&nbsp;</span>as you want according to the on-screen instructions.</p><p>Usually, PayPal e-check will take 3-5 business days to be confirmed by<span>&nbsp;</span><strong>PayPal</strong>.</p><p>The reasons why we suggest you use<span>&nbsp;</span><strong>PayPal</strong>:<br>Payment is traceable. By using your<span>&nbsp;</span><strong>PayPal</strong><span>&nbsp;</span>account, you can trace the status of your payment.<br>When you make payment for your order, you don’t need to use your credit card online (you can transfer directly from your bank account). When you use your credit card through PayPal, nobody will see your credit card number, which will minimize the risk of unauthorized use.</p>',
            'visibility' => true
        ]);
    }
}