<?php

namespace Database\Seeders;

use App\Models\Config;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\File;

class AppSeeder extends Seeder
{
    public function run()
    {
        User::create([
            'name' => 'AACHDEV',
            'email' => 'admin@admin.com',
            'password' => bcrypt('Admin@1996-'),
            'is_admin' => true
        ]);
        
        Config::create([ 'name' => 'website_title', 'value' => config('app.name') ]);
        Config::create([ 'name' => 'website_description', 'value' => 'Your Gym, Your Rules - Download, Sweat, Succeed!' ]);

        Config::create([ 'name' => 'paypal_shuffled', 'value' => false ]);
        Config::create([ 'name' => 'about_us', 'value' => 'Your Gym, Your Rules - Download, Sweat, Succeed!' ]);
        Config::create([ 'name' => 'cta_message', 'value' => 'Find things you\'ll love' ]);
        Config::create([ 'name' => 'favicon', 'value' => 'favicon.ico' ]);
        
        File::copy(public_path('app_images/white.png'), 'storage/app/public/white.png');
        File::copy(public_path('app_images/black.png'), 'storage/app/public/black.png');
        File::copy(public_path('app_images/favicon.ico'), 'storage/app/public/favicon.ico');        
        Config::create([ 'name' => 'white', 'value' => 'white.png' ]);
        Config::create([ 'name' => 'black', 'value' => 'black.png' ]);

        Config::create([ 'name' => 'isDigital', 'value' => true ]);

    
    }
}
